;; A useful procedure to display a 8-bit number in binary
;;

.txt_output equ &bb5a

;;------------------------------
;; DISPLAY A BYTE IN BINARY FORM 
;;
;; Enter:
;; A = 8-bit value
;;
;; Exit:
;; AF corrupt.
;; B corrupt. 
;; All other registers preserved

.display_binary
ld b,8                    ;number of bits to display

.get_bit
rlca                      ;rotate current top bit into carry

                          ;if the bit was 1, the carry is set. (i.e. carry=1)
                          ;if the bit was 0, the carry is reset. (i.e carry=0)

push af
ld a,"0"                  ;ASCII character for bit value
adc a,0                   ;add carry, if carry is set A="1", otherwise A="0"
call txt_output           ;display character onscreen
pop af

djnz get_bit              ;loop, until all bits have been displayed
ret
	